﻿using gov.va.med.vbecs.BOL;
using gov.va.med.vbecs.Common;
using gov.va.med.vbecs.GUI;
using gov.va.med.vbecs.GUI.WPF;
using System.Collections.Generic;
using System.Windows.Forms;
using WPF.PresentationLayer.UC115.Views;

namespace WPF.PresentationLayer.UC115.ViewModels
{
    public class PatientXMatchViewModel : SpecimenTabViewModel
    {
        /// <summary>
        /// Command to open the product code selection dialog
        /// </summary>
        public DelegateCommand<SpecimenXMatchItemViewModel> ProductCodeCommand { get; private set; }

        /// <summary>
        /// Constructor
        /// </summary>
        /// <param name="patient"></param>
        /// <param name="specimentUid"></param>
        /// <param name="vbecsBaseForm"></param>
        /// <param name="pendingSpecimenTestList"></param>
        public PatientXMatchViewModel(Patient patient, string specimentUid, VbecsBaseForm vbecsBaseForm, IEnumerable<SpecimenXMatchItemViewModel> pendingSpecimenTestList)
            : base(patient, specimentUid, vbecsBaseForm, pendingSpecimenTestList, StrRes.HelpFiles.UC115.AutomatedTestingPatientXMatchTab())
        {
            ProductCodeCommand = new DelegateCommand<SpecimenXMatchItemViewModel>(OnProductCodeCommand);
        }

        /// <summary>
        /// OnProductCodeCommand
        /// </summary>
        /// <param name="selectedUnit"></param>
        private void OnProductCodeCommand(SpecimenXMatchItemViewModel selectedUnit)
        {
            PromptForBloodUnit(selectedUnit);
        }

        /// <summary>
        /// Prompt the user to enter a product code
        /// </summary>
        /// <param name="selectedUnit"></param>
        private void PromptForBloodUnit(SpecimenXMatchItemViewModel selectedUnit)
        {
            if (selectedUnit != null)
            {
                var originalTestValidationStatus = TestValidationStatus.Unknown;
                if (selectedUnit.TestValidation != null)
                {
                    originalTestValidationStatus = selectedUnit.TestValidation.TestValidationStatus;
                }
                var dlg = ViewConstructor.CreateFormAndView<BloodUnitProductCodeView, FrmWPFContainer>();                
                // Defect 282082
                var dlgViewModel = new BloodUnitProductCodeViewModel(selectedUnit.PendingSpecimenXMatchModel.BloodUnitId, selectedUnit.PendingSpecimenTestModel.SpecimenUid, selectedUnit.BloodUnitModel, dlg);
                dlgViewModel.LogoHeaderText = "Select Product Code";
                dlg.WPFUserControl.DataContext = dlgViewModel;
                var dlgResult = dlg.ShowDialogFromLockedParent(VbecsBaseForm, false);

                if (dlgResult == DialogResult.OK &&
                    dlgViewModel.SelectedBloodUnit != null)
                {
                    selectedUnit.BloodUnitModel = dlgViewModel.SelectedBloodUnit.Clone();

                    if (selectedUnit.TestValidation == null ||
                        originalTestValidationStatus != selectedUnit.TestValidation.TestValidationStatus)
                    {
                        // Test Validation changed so uncheck all other tests
                        // and select this test
                        base.UncheckAll(PendingSpecimenList);

                        System.Windows.Application.Current.Dispatcher.BeginInvoke(new System.Action(() =>
                        {
                            selectedUnit.IsSelected = true;
                            OnItemSelectedCommand(selectedUnit);
                        }));
                    }
                }
            }
        }
    }
    //public class PatientXMatchViewModel : AutomatedTestViewModel
    //{
    //    public DelegateCommand<PatientCrossmatch> ProductCodeCommand { get; private set; }

    //    public PatientXMatchViewModel(Patient patient, VbecsBaseForm vbecsBaseForm)
    //        : base(patient, vbecsBaseForm, PatientCrossmatch.GetMockData())
    //    {
    //        ProductCodeCommand = new DelegateCommand<PatientCrossmatch>(OnProductCodeCommand);
    //    }

    //    public override void OnItemSelectedCommand(ISelectableTest selectableTest)
    //    {
    //        base.OnItemSelectedCommand(selectableTest);

    //        var selectedUnit = selectableTest as PatientCrossmatch;

    //        if (selectedUnit != null &&
    //            selectedUnit.ProductCode == null)
    //        {
    //            // No Product code exists so we need to prompt the user to select one
    //            PromptForProductCode(selectedUnit);

    //            if (selectedUnit.ProductCode == null)
    //            {
    //                // No product code was selected so we will uncheck the user's selection
    //                System.Windows.Application.Current.Dispatcher.BeginInvoke(new System.Action(() =>
    //                {
    //                    selectableTest.IsSelected = false;
    //                }));
    //            }
    //        }
    //    }

    //    private void OnProductCodeCommand(PatientCrossmatch selectedTest)
    //    {
    //        PromptForProductCode(selectedTest);
    //    }

    //    private void PromptForProductCode(PatientCrossmatch selectedTest)
    //    {
    //        if (selectedTest != null)
    //        {
    //            var dlg = ViewConstructor.CreateFormAndView<BloodUnitProductCodeView, FrmWPFContainer>();
    //            var dlgViewModel = new BloodUnitProductCodeViewModel(selectedTest.UnitID, selectedTest.ProductCode, dlg);
    //            dlgViewModel.LogoHeaderText = "Select Product Code";
    //            dlg.WPFUserControl.DataContext = dlgViewModel;
    //            var dlgResult = dlg.ShowDialog(VbecsBaseForm);

    //            if (dlgResult == DialogResult.OK)
    //            {
    //                selectedTest.ProductCode = dlgViewModel.SelectedBloodUnit;
    //            }
    //        }
    //    }
    //}
}
